/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.item.heal;

import dev.toma.gunsrpg.ModTabs;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.client.animation.ModAnimations;
import dev.toma.gunsrpg.client.render.RenderConfigs;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.item.BaseItem;
import dev.toma.gunsrpg.util.SkillUtil;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import lib.toma.animations.AnimationEngine;
import lib.toma.animations.api.Animation;
import lib.toma.animations.api.IAnimation;
import lib.toma.animations.api.IAnimationEntry;
import lib.toma.animations.api.IAnimationLoader;
import lib.toma.animations.api.IAnimationPipeline;
import lib.toma.animations.api.IKeyframeProvider;
import lib.toma.animations.api.IRenderConfig;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;

public abstract class AbstractHealItem<T>
extends BaseItem
implements IAnimationEntry {
    private final int useTime;
    private final ITextComponent[] description;
    private final Predicate<T> useCondition;
    private final Consumer<T> useAction;
    private final ResourceLocation useAnimation;

    protected AbstractHealItem(HealBuilder<T, ?> builder) {
        this(builder, new Item.Properties().func_200917_a(10));
    }

    protected AbstractHealItem(HealBuilder<T, ?> builder, Item.Properties properties) {
        super(builder.name, properties.func_200916_a(ModTabs.ITEM_TAB));
        this.useTime = ((HealBuilder)builder).useTime;
        this.description = ((HealBuilder)builder).description;
        this.useCondition = ((HealBuilder)builder).useCondition;
        this.useAction = ((HealBuilder)builder).useAction;
        this.useAnimation = ((HealBuilder)builder).useAnimation;
    }

    public abstract T getTargetObject(World var1, PlayerEntity var2, IPlayerData var3);

    public void func_77624_a(ItemStack stack, World level, List<ITextComponent> list, ITooltipFlag flag) {
        list.addAll(Arrays.asList(this.description));
    }

    public int func_77626_a(ItemStack stack) {
        return this.useTime;
    }

    public UseAction func_77661_b(ItemStack p_77661_1_) {
        return UseAction.NONE;
    }

    public ActionResult<ItemStack> func_77659_a(World level, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        LazyOptional<IPlayerData> optional = PlayerData.get(player);
        if (optional.isPresent()) {
            IPlayerData data = (IPlayerData)optional.orElse(null);
            T target = this.getTargetObject(level, player, data);
            CooldownTracker tracker = player.func_184811_cZ();
            if (this.useCondition.test(target) && !tracker.func_185141_a(stack.func_77973_b())) {
                if (level.field_72995_K) {
                    AnimationEngine engine = AnimationEngine.get();
                    IAnimationLoader loader = engine.loader();
                    IAnimationPipeline pipeline = engine.pipeline();
                    IAnimation animation = this.constructAnimation(loader.getProvider(this.useAnimation), this.getAnimationLength());
                    pipeline.insert(ModAnimations.HEAL, animation);
                }
                player.func_184598_c(hand);
                return ActionResult.func_226250_c_((Object)stack);
            }
        }
        return ActionResult.func_226251_d_((Object)stack);
    }

    public void func_77615_a(ItemStack p_77615_1_, World p_77615_2_, LivingEntity p_77615_3_, int p_77615_4_) {
        if (p_77615_2_.field_72995_K) {
            AnimationEngine.get().pipeline().remove(ModAnimations.HEAL);
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            PlayerData.get(player).ifPresent(data -> {
                if (!world.field_72995_K) {
                    T target = this.getTargetObject(world, player, (IPlayerData)data);
                    this.applyAction(target);
                    if (this.shouldApplyHealBonus()) {
                        SkillUtil.heal(player, 0.0f);
                    }
                }
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
            });
            CooldownTracker tracker = player.func_184811_cZ();
            tracker.func_185145_a(stack.func_77973_b(), 30);
        }
        return stack;
    }

    @Override
    public IRenderConfig left() {
        return RenderConfigs.HEAL_CONFIG;
    }

    @Override
    public IRenderConfig right() {
        return RenderConfigs.HEAL_CONFIG;
    }

    @Override
    public boolean disableVanillaAnimations() {
        return false;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public int getUseTime() {
        return this.useTime;
    }

    protected void applyAction(T target) {
        this.useAction.accept(target);
    }

    protected int getAnimationLength() {
        return this.useTime;
    }

    protected IAnimation constructAnimation(IKeyframeProvider provider, int length) {
        return new Animation(provider, length);
    }

    protected boolean shouldApplyHealBonus() {
        return true;
    }

    protected Predicate<T> getUseCondition() {
        return this.useCondition;
    }

    public static abstract class HealBuilder<T, H extends AbstractHealItem<T>> {
        protected final String name;
        private int useTime;
        private ITextComponent[] description = new ITextComponent[0];
        private Predicate<T> useCondition = t -> true;
        private Consumer<T> useAction;
        private ResourceLocation useAnimation;

        protected HealBuilder(String name) {
            this.name = name;
        }

        private static <T extends ITextComponent> T[] convert(String[] array, Function<String, T> mapper, IntFunction<T[]> arrayFactory) {
            return (ITextComponent[])Arrays.stream(array).map(mapper).toArray(arrayFactory);
        }

        public abstract H build();

        public HealBuilder<T, H> canUse(Predicate<T> useCondition) {
            this.useCondition = useCondition;
            return this;
        }

        public HealBuilder<T, H> onUse(Consumer<T> useAction) {
            this.useAction = useAction;
            return this;
        }

        public HealBuilder<T, H> animate(int useTime, ResourceLocation animationPath) {
            this.useTime = useTime;
            this.useAnimation = animationPath;
            return this;
        }

        public HealBuilder<T, H> describe(ITextComponent ... lines) {
            this.description = lines;
            return this;
        }

        public HealBuilder<T, H> describe(String ... lines) {
            return this.describe(HealBuilder.convert((String[])lines, StringTextComponent::new, StringTextComponent[]::new));
        }

        public HealBuilder<T, H> translate(String ... keys) {
            return this.describe(HealBuilder.convert((String[])keys, TranslationTextComponent::new, TranslationTextComponent[]::new));
        }
    }
}

